/********************* (C) COPYRIGHT 2010 e-Design Co.,Ltd. ********************
 File Name : file.c  
 Version   : DS203_APP Ver 2.4x                                  Author : bure
*******************************************************************************/
#include <string.h>
#include <stdio.h>
#include "Interrupt.h"
#include "Function.h"
#include "Process.h"
#include "BIOS.h"
#include "File.h"
#include "Draw.h"
#include "Menu.h"
//#include "dosfs.h"

u8  SecBuff[512];
u8  FileBuff[1200];
u16 TempPar[66];
u16 BMP_Color[16] = { WHT,  CYAN, CYAN_,  YEL,  YEL_, PURPL, PURPL_, GRN,   
                      GRN_, GRAY, ORANGE, BLUE, RED,  BLACK, BLACK,  BLACK};    
u8 BmpHead[54]    = { 0X42, 0X4D, 0XF8, 0XB, 0X00, 0X00, 0X00, 0X00, 
                      0X00, 0X00, 0X76, 0X0, 0X00, 0X00, 0X28, 0X00,
                      0X00, 0X00, 0X90, 0X1, 0X00, 0X00, 0XF0, 0X00,
                      0X00, 0X00, 0X01, 0X0, 0X04, 0X00, 0X00, 0X00,
                      0X00, 0X00, 0X82, 0XB, 0X00, 0X00, 0X12, 0X0B,
                      0X00, 0X00, 0X12, 0XB, 0X00, 0X00, 0X00, 0X00,
                      0X00, 0X00, 0X00, 0X0, 0X00, 0X00};

/*******************************************************************************
 ָչļ            룺ļչ             ֵ0x00=ɹ 
*******************************************************************************/
u8 Make_Filename(u8 FileNum, u8* FileName)
{
  u8 Num[4];
  
  u8ToDec3(Num, FileNum);
  FileName[4]  = Num[0];
  FileName[5]  = Num[1];
  FileName[6]  = Num[2];
  FileName[12] = 0;
  return 0;
} 
/*******************************************************************************
Save_Dat: 浱ǰĻʾͼԭʼ    룺ļ     ֵ0x00=ɹ 
*******************************************************************************/
u8 Save_Dat(u8 FileNum)
{
  u8  Sector[512], Filename[13] = "FILE    .DAT"; 
  u16 i, j, Rvalue = 1;
  u32 Cache; 
  
  VOLINFO  vi;
  FILEINFO fi;

  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){
    if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)==0){
      memset(SecBuff, 0, 512);
      for(j=0; j<4; j++){
        for(i=0; i<299; i++)  SecBuff[i] = TrackBuff[i*4 + j];
        SecBuff[299] = Title[j][POSI].Value;
        if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return Rvalue;
      }
      return 0;
    }
  }
  return Rvalue;
}
/*******************************************************************************
Load_Dat: رĻͼԭʼ    룺ļ     ֵ0x00=ɹ 
*******************************************************************************/
u8 Load_Dat(u8 FileNum)
{
  u8  Sector[512], Filename[13] = "FILE    .DAT"; 
  u32 Cache;
  u16 i, Rvalue = 1;
  
  VOLINFO  vi;
  FILEINFO fi;
  
  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){
    if(__DFS_OpenFile(&vi, Filename, DFS_READ, SecBuff, &fi)==0){
      for(i=0; i<4; i++){
        if(__DFS_ReadFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return Rvalue+1;
        memcpy(&FileBuff[i*300], SecBuff,300);
      }
      return 0;
    } else return Rvalue+2;
  }
  return Rvalue;
}
/*******************************************************************************
Save_Bmp: 浱ǰĻʾͼΪBMPʽ    룺ļ     ֵ0x00=ɹ 
*******************************************************************************/
u8 Save_Bmp(u8 FileNum)
{
  u8  k, Sector[512], Filename[13] = "IMAG   .BMP"; 
  u32 Cache; 
  u16 i, j, x=0, y=0, ColorH, ColorL, Rvalue=1;

  VOLINFO  vi;
  FILEINFO fi;

  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){ 
    if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)==0){
      memcpy(SecBuff, BmpHead, 54);
      i = 0x0036; // ɫſʼַ
      for(j=0; j<16; ++j){
        SecBuff[j*4 +i+0]=(BMP_Color[j]& 0xF800)>>8; // Bule
        SecBuff[j*4 +i+1]=(BMP_Color[j]& 0x07E0)>>3; // Green
        SecBuff[j*4 +i+2]=(BMP_Color[j]& 0x001F)<<3; // Red
        SecBuff[j*4 +i+3]= 0;                        // Alpha
      }
      i = 0x0076; // ͼݿʼŵַ
      k = 0;
      for(y=0; y<240; y++){
        for(x=0; x<400 ; x+=2){
          __Point_SCR(x, y);
          ColorH =__LCD_GetPixl();
          __Point_SCR(x+1, y);
          ColorL =__LCD_GetPixl();
          SecBuff[i] =(Color_Num(ColorH)<<4)+ Color_Num(ColorL);
          i++;
          if(i>=512){
            if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return 0x01;
            Print_Clk(254, 0, (SCRN<<8)+ TEXT1, (k>>2) & 3);    // ָʾ
            i=0; 
            k++;
          }
        }
      }
      if(i!=0)
        if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return 0x01;
      return 0; 
    }
  }
  return Rvalue;
}
/*******************************************************************************
Save_Buf: ɼݻΪBUFʽ    룺ļ     ֵ0x00=ɹ      
*******************************************************************************/
u8 Save_Buf(u8 FileNum)
{
  u8  i, Sector[512], Filename[13] = "DATA   .BUF"; 
  u32 Cache; 
  u16* p ;
  
  VOLINFO  vi;
  FILEINFO fi;
  
  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)!=0) return 1;
  if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)!=0) return 2;
  for(i=0; i<32; i++){
    memcpy(SecBuff, &(DataBuf[i*512/4]), 512);
    if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return i+3;
  }
  memset(SecBuff, 0, 512);
  p =(u16*)SecBuff;
  for(i=0; i<4; i++){                     // ʾ˵иӦֵ
    *p++ = Title[i][0].Value;
    *p++ = Title[i][1].Value;
    *p++ = Title[i][2].Value;
    *p++ = Title[i][3].Value;
  }
  *p++ = Title[5][0].Value;
  *p++ = Title[5][1].Value;

  *p++ = 0x00FF & Ka1[_A_Range];
  *p++ = Ka2[_A_Range];
  *p++ = 0x00FF & Kb1[_B_Range];
  *p++ = Kb2[_B_Range];

  if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return 35;
  return 0;
}
/*******************************************************************************
Load_Dat: رĲɼݻ    룺ļ     ֵ0x00=ɹ 
*******************************************************************************/
u8 Load_Buf(u8 FileNum)
{
  u8  i, Sector[512], Filename[13] = "DATA    .BUF"; 
  u32 Cache;
  u16 *p;
  
  VOLINFO  vi;
  FILEINFO fi;
  
  p = TempPar;
  *p++ = 0xaa55;
  for(i=0; i<4; i++){                     // ʾ˵иӦֵ
    *p++ = Title[i][0].Value;
    *p++ = Title[i][1].Value;
    *p++ = Title[i][2].Value;
    *p++ = Title[i][3].Value;
  }
  *p++ = Title[5][0].Value;
  *p++ = Title[5][1].Value;
  for(i=0; i<8; i++){
    *p++ = 0x00FF & Ka1[i];
    *p++ = Ka2[i];
    *p++ = 0x00FF & Kb1[i];
    *p++ = Kb2[i];
  }
  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)!=0) return 1;
  if(__DFS_OpenFile(&vi, Filename, DFS_READ, SecBuff, &fi)!=0) return 2;
  for(i=0; i<32; i++){
    if(__DFS_ReadFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return i+3;
    memcpy(&(DataBuf[i*512/4]),SecBuff,512);
  }
  if(__DFS_ReadFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return i+4;
  p =(u16*)SecBuff;
  for(i=0; i<4; i++){
    Title[i][0].Value = *p++;             // ֮ǰʾ˵иӦֵ
    Title[i][1].Value = *p++ ;
    Title[i][2].Value = *p++;
    Title[i][3].Value = *p++;
    Title[i][0].Flag  = UPDAT;
    Title[i][1].Flag  = UPDAT;
    Title[i][2].Flag  = UPDAT;
    Title[i][3].Flag  = UPDAT;
  }
  Title[5][0].Value = *p++;
  Title[5][1].Value = *p++;
  Title[5][0].Flag  = UPDAT;
  Title[5][1].Flag  = UPDAT;
      
  Ka1[_A_Range] = (*p++ );
  Ka2[_A_Range] = (*p++ );
  Kb1[_B_Range] = (*p++);
  Kb2[_B_Range] = (*p++); /**/

  Title[RUNNING][STATE].Value = 1;                 // "HOLD" ״̬
  Title[RUNNING][STATE].Flag |= UPDAT;             // Ӧĸ±־
  return 0;
}

void reset_parameter(void)
{
  u16* p;
  u8   i;
  
  p=TempPar;
  p++;
  if(TempPar[0]!=0xaa55) return;
  for(i=0; i<4; i++){
    Title[i][0].Value = *p++;             // ֮ǰʾ˵иӦֵ
    Title[i][1].Value = *p++;
    Title[i][2].Value = *p++;
    Title[i][3].Value = *p++;
    Title[i][0].Flag  = UPDAT;
    Title[i][1].Flag  = UPDAT;
    Title[i][2].Flag  = UPDAT;
    Title[i][3].Flag  = UPDAT;
  }
  Title[5][0].Value = *p++;
  Title[5][1].Value = *p++;
  Title[5][0].Flag  = UPDAT;
  Title[5][1].Flag  = UPDAT;
  
  for(i=0; i<8; i++){
    Ka1[i] = (s8)(*p++ );//& 0xff);
    Ka2[i] = (*p++ );
    Kb1[i] = (s8)(*p++);// & 0xff);
    Kb2[i] = (*p++);
  }
  p = TempPar;
  *p++ = 0;
}

void make_Vertical(u8 TRACK,u8* buf,u8* len)
{
  u8 i=0;
  u8* ptr;

  ptr = &Vertical[0][0] + 10*Title[TRACK][2].Value;
  while(*ptr != 0){
    if(*ptr == 0x21)  buf[i] = 0x20;
    else              buf[i] = *ptr;
    ptr++;
    i++;
  };
  buf[i]   = 0x2c;
  buf[i+1] = 0;
  *len = i+1;
}
/*******************************************************************************
Save_Csv: ɼݻΪCSVʽ    룺ļ     ֵ0x00=ɹ      
*******************************************************************************/
u8 Save_Csv(u8 FileNum)
{
  u8  Num[4], track[4], Sector[512], Filename[13] = "DATA   .CSV"; 
  u32 i, k=0, Cache, Rvalue=1;
  s16 temp;
  u8  count, v, j;
  
  VOLINFO  vi;
  FILEINFO fi;

  Make_Filename(FileNum, Filename);
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){
    if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)==0){
      make_Vertical(TRACK1, Sector, &count);
      memcpy(SecBuff, "TRACK1 ", 7);
      memcpy(&SecBuff[7], Sector, count);
      v = 7 + count;
      make_Vertical(TRACK2, Sector, &count);
      memcpy(&SecBuff[v], "TRACK2 ", 7);
      memcpy(&SecBuff[v+7], Sector, count);
      v += 7 + count;
      memcpy(&SecBuff[v], "TRACK3,TRACK4,\r\n", 15);
      k = v + 15;
      for(i=0; i<4096; i++){
        temp=Ka1[_A_Range]+((Ka2[_A_Range]*(DataBuf[i] & 0xff))+512)/1024;
        if(temp > 0){
          if(temp > 200)  track[0] = 199;
          else            track[0] = temp;
        } else            track[0] = 0;
        temp = Kb1[_B_Range]+((Kb2[_B_Range]*(DataBuf[i] & 0xff00)>>8)+512)/1024;
        if(temp > 0){
          if(temp > 200)  track[1] = 199;
          else            track[1] = temp;
        } else            track[1] = 0;
        if((DataBuf[i] & 0x010000)==0)  track[2] = Title[TRACK3][POSI].Value;
        else                            track[2] = 20 + Title[TRACK3][POSI].Value;
        if((DataBuf[i] & 0x020000)==0)  track[3] = Title[TRACK4][POSI].Value;
        else                            track[3] = 20 + Title[TRACK4][POSI].Value;
        for(j=0; j<4; j++){
//          sprintf(Num, "%03d", track[j]);
          u8ToDec3(Num, track[j]);
          for(count=0; count<3; count++){
            if(Num[count] == 0) break;
            SecBuff[k] = Num[count];
            k++;
            if(k >= 512){
              k = 0;
              if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return Rvalue;
              Print_Clk(254, 0, (SCRN<<8)+ TEXT1, (v >> 2) & 3);    // ָʾ
              v++;
            }
          }
          SecBuff[k] = 0x2c;
          k++;
          if(k >= 512){
            k = 0;
            if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return Rvalue;
            Print_Clk(254, 0, (SCRN<<8)+ TEXT1, (v >> 2) & 3);    // ָʾ
            v++;
          }
        }
        SecBuff[k] = 0x0d;
        k++;
        SecBuff[k] = 0x0a;
        k++;
        if(k >= 512){
          k = 0;
          if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return Rvalue;
          Print_Clk(254, 0, (SCRN<<8)+ TEXT1, (v >> 2) & 3);    // ָʾ
          v++;
        }
      }
      if(k != 0){
        SecBuff[k]=0x0d;
        k++;
        SecBuff[k]=0x0a;
        k++;
        memset(&SecBuff[k],0,(512-k));
        k=0;
        if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0)return Rvalue;
        Print_Clk(254, 0, (SCRN<<8)+ TEXT1, (v >> 2) & 3);    // ָʾ
        v++;
      }
    }
    return 0; 
  }
  return Rvalue;
}
/******************************************************************************************/
u8 Color_Num(u16 Color)
{
  if(Color == WHT)                   return 0;
  else if((Color & CYAN  )== CYAN  ) return 1;
  else if((Color & YEL   )== YEL   ) return 3;
  else if((Color & PURPL )== PURPL ) return 5;
  else if((Color & GRN   )== GRN   ) return 7;
  else if((Color & CYAN_ )== CYAN_ ) return 2;
  else if((Color & YEL_  )== YEL_  ) return 4;
  else if((Color & PURPL_)== PURPL_) return 6;
  else if((Color & GRN_  )== GRN_  ) return 8;
  else if((Color & GRAY  )== GRAY  ) return 9;
  else if((Color & ORANGE)== ORANGE) return 10;
  else if((Color & BLUE  )== BLUE  ) return 11;
  else if((Color & RED   )== RED   ) return 12;
  else                               return 13;
}
/*******************************************************************************
Load_Parameter: ֮ǰĹ                           Return: 0= Success
*******************************************************************************/
u8 Load_Param(void)
{ 
  u8  Sum = 0, Sector[512], Filename[13], Versions = 0x07; 
  u16 i, Rvalue = 1;
  u32 Cache; 
  u16* p =(u16*)SecBuff;
  
  VOLINFO  vi;
  FILEINFO fi;
  
  Word2Hex(Filename, __GetDev_SN());
  Filename[8] = '.';  Filename[9] = 'W'; Filename[10] = 'P'; 
  Filename[11] = 'T'; Filename[12] = 0;
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){
    if(__DFS_OpenFile(&vi, Filename, DFS_READ, SecBuff, &fi)==0){
      if(__DFS_ReadFile(&fi, Sector, SecBuff, &Cache, 512)!=0) return Rvalue +1;
      if(Versions !=(*p & 0xFF)) return Rvalue +2;          // 汾
      for(i=0; i<512; ++i) Sum += SecBuff[i];
      if(Sum != 0) return Rvalue +3;                        // Уͳ
      Current =(*p++ >>8);                    // ֮ǰ Current Title
      for(i=0; i<7; i++){ 
        Detail[i*2]  = *p;
        Detail[i*2+1]= (*p++ >>8);             // ֮ǰ Detail
      }
      for(i=0; i<12; i++){                     // ʾ˵иӦֵ
        Trigg[i].Track=*p++ ;
        Trigg[i].Value1=*p++;
        Trigg[i].Value2=*p++;
      }

      for(i=0; i<9; i++){
        Meter[i].Item     = *p;
        Meter[i].Track    =(*p++ >>8);        // ֮ǰĲĿ
      }
      for(i=0; i<10; i++){
        Ka1[i] = *p;                         // ָԭ A ͨλУϵ
        Kb1[i] =(*p++ >>8);                  // ָԭ B ͨλУϵ
        Ka2[i] = *p++;                       // ָԭ A ͨУϵ
        Kb2[i] = *p++;                       // ֮ǰ B ͨУϵ
        Ka3[i] = *p;                         // ָԭ A ͨλУϵ
        Kb3[i] =(*p++ >>8);                  // ָԭ B ͨλУϵ
      }
      V_Trigg[A].Value = *p++;
      V_Trigg[B].Value = *p++;               // ָԭA,Bֵͨ
      return 0;
    }
    return Rvalue+4;
  }
  return Rvalue;
}
/*******************************************************************************
 Save_Parameter: 浱ǰĹ                          Return: 0= Success
********************************************************************************/
u8 Save_Param(void)             // 湤ļ
{
  u8  Sum = 0, Sector[512], Filename[13], Versions = 0x07; 
  u16 i, Rvalue = 1;
  u32 Cache; 
  u16* p =(u16*)SecBuff;
  
  VOLINFO  vi;
  FILEINFO fi;
  
  Word2Hex(Filename, __GetDev_SN());
  Filename[8] = '.';  Filename[9] = 'W'; Filename[10] = 'P'; 
  Filename[11] = 'T'; Filename[12] = 0;
  if(__DFS_GetVolInfo(0, SecBuff, 0, &vi)==0){
    if(__DFS_OpenFile(&vi, Filename, DFS_READ, SecBuff, &fi)==0){
      Rvalue = __DFS_ReadFile(&fi, Sector, SecBuff, &Cache, 512);
    }
    Filename[9] = 'B'; Filename[10] = 'A'; Filename[11] = 'K';
    if(Rvalue == 0){
      memcpy(Sector, SecBuff, 512);
      if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)==0){
        memcpy(SecBuff, Sector, 512);
        Rvalue = __DFS_WriteFile(&fi, Sector, SecBuff, &Cache, 512);
      }
    }
    Filename[9] = 'W'; Filename[10] = 'P'; Filename[11] = 'T';
    if(__DFS_OpenFile(&vi, Filename, DFS_WRITE, SecBuff, &fi)==0){
//      memset(SecBuff, 0, 512);
      *p++ =(Current <<8)+ Versions;           // 汾żǰ Title
      for(i=0; i<7; i++){ 
        *p++ =(Detail[i*2+1]<<8)+ Detail[i*2]; // 浱ǰ Detail
      }
      
      for(i=0; i<12; i++){                     // ʾ˵иӦֵ
        *p++ = Trigg[i].Track;
        *p++ = Trigg[i].Value1;
        *p++ = Trigg[i].Value2;
      }
      for(i=0; i<9; i++){
        *p++ =(Meter[i].Track<<8)+ Meter[i].Item; // Ŀ
      }
      for(i=0; i<10; i++){
        *p++ = (Kb1[i]<<8)+ Ka1[i];             // 浱ǰ A,B ͨλУϵ
        *p++ =  Ka2[i];                         // 浱ǰ A ͨУϵ
        *p++ =  Kb2[i];                         // 浱ǰ B ͨУϵ
        *p++ = (Kb3[i]<<8)+ Ka3[i];             // 浱ǰ A,B ͨλУϵ
      }
      *p++ = V_Trigg[A].Value;
      *p++ = V_Trigg[B].Value;                 // 浱ǰA,Bֵͨ   
      for(i=0; i<512; i++)  Sum += SecBuff[i]; //У
      SecBuff[511] = (~Sum)+ 1;
      if(__DFS_WriteFile(&fi, Sector, SecBuff, &Cache, SECTOR_SIZE)!=0) return Rvalue;
    }
    return 0;
  }
  return Rvalue;
}

/******************************** END OF FILE *********************************/

